<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Categories extends CI_Controller {

	function __construct(){
		parent::__construct();
		check_admin_session();
		$this->load->model("adminmodel","",true);
		$this->load->model("common_model","",true);
		$this->load->model("categorymodel","",true);
		$this->admin->nocache(); 
	}
	
    public function index() {
    	//check_permission(6,'uri');
        $data = $this->admin->common_admin_files();
		$data['title']="Categories";
		$this->load->view("admin/categories/categories_view",$data);
    }

     function get_datas(){
		$data = $this->categorymodel->get_categories_json();
		$res = array(
			'menus' => $data,
		);
		$value = withSuccess("Categories", $res);
		echo json_encode($value);
	}

	function edit_cat() {
        //check_permission(6,'json');
		$id=$this->input->post('id');
        $data = array();
        $where = array('id' => $id );
        $data['dataQ']=$this->common_model->get_table_data('categories',$where,'*',true);
		$msg=$this->load->view("admin/categories/edit_categories_view",$data,true);		

		$value=array(
			'status'=>'success',
			'msg'=>$msg
		);
		
		echo json_encode($value);
    }

	function check_exists(){
		$name=$this->admin->escapespecialchrs(trim($this->input->post('text')));
		$edit=$this->admin->escapespecialchrs($this->input->post('edit'));
		$q=0;
		if(strtolower($edit)!=strtolower($name)){
        	$where = array('text' => $name );
			$query=$this->common_model->get_table_data('categories',$where,'*',true);
			$q=$query->num_rows();
		}
		$result="true";
		if($q>0){
			$result="false";
		}		
		echo $result;
	}

	function check_add_exists(){
		$name=$this->admin->escapespecialchrs(trim($this->input->post('cat_name')));
		$edit=$this->admin->escapespecialchrs($this->input->post('edit'));
		$q=0;
		if(strtolower($edit)!=strtolower($name)){
        	$where = array('text' => $name );
			$query=$this->common_model->get_table_data('categories',$where,'*',true);
			$q=$query->num_rows();
		}
		$result="true";
		if($q>0){
			$result="false";
		}		
		echo $result;
	}

	function save_update(){
		$data['id']=$this->input->post("id");
		$text=$this->input->post("text");
		$cat_name=$this->input->post("cat_name");
        $image_old=$this->input->post("image_old");
        $status=$this->input->post("status");
		$data['createdDate']=cur_datetime();
		$data['updatedDate']=cur_datetime();
		
		$result=0;
		
		if($data['id']!='' && $text!==''){
			$data['text']=$text;
			$data['status']=$status;
		}else{
			$data['text']=$cat_name;
			$data['status']=1;
		}
		$data['slug']=create_slug($data['text']);

		$msg="No changes saved...";
		$res_file=0;
        $dir = 'uploads/categories/'.$data['id'].'/';
        if (!file_exists($dir )) {
            mkdir($dir , 0777, true);
        }
        $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
        if(!empty($_FILES)){
            //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
            for($i=0;$i<1;$i++)
            {
                $key = $i;
                if(!empty($_FILES['attachment']['tmp_name'][$key])){
                    $file_name = $_FILES['attachment']['name'][$key];
                    $file_size =$_FILES['attachment']['size'][$key];
                    $file_tmp =$_FILES['attachment']['tmp_name'][$key];
                    $file_type=$_FILES['attachment']['type'][$key];        
                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                    if($file_size > 2048) {
                        $msg='File size should not exceed 2 MB';
                    }
                    if(in_array($ext,$extensions ) === true)
                    {  

                        $target = $dir.$file_name;
                        if(file_exists($target)){
                            $file_name = rand(01,1000).$file_name;
                        }
                        $target = $dir.$file_name;
                        if(move_uploaded_file($file_tmp, $dir.$file_name))
                        {
                            $data['image']=$file_name;
                            $res_file=1;
                        }else{
                            $msg = 'Error in uploading file';               
                        }
                    
                    }else{
                        $msg = 'Error in uploading file. <br>File type is not allowed.';
                    }
                }else{
                    $data['image']=$image_old;
                    $res_file=1;
                }
            }
        }else{
            $data['image']=$image_old;
            $res_file=1;
        }
        if($res_file==1){
			$q=$this->categorymodel->savecategory($data);
			$result=$q['res'];
			$msg=$q['msg'];
		}
		$value=array(
			'result'=>$result,
			'msg'=>$msg
		);
		
		echo json_encode($value);
	}

	function save_categories(){
		$datas = json_decode($this->input->post('str'));		
		$readbleArray = $this->parseJsonArray($datas);

		$i=0;
		foreach($readbleArray as $row){
			$i++;
			$where = array('id'=>$row['id']);
			$data = array(
				'parent'=>$row['parentID'],
				'orders'=>$i
			);
			$this->common_model->update_table_data('categories',$where,$data);			
		}		

        $logData['action']='update';
        $logData['description']='Updated and reordered the categories';
		$logData['dataId']='';
        $logData['module']='categories';
        $logData['table_name']='categories';
        insert_a_log($logData);
		
		$cat_data = $this->categorymodel->get_categories_json();	
		$res = array(
			'menus' => $cat_data,
		);
		$value = withSuccess("Categories", $res);
		echo json_encode($value);
	}

	function parseJsonArray($jsonArray, $parentID = 0) {
	//print_r($jsonArray);
	  $return = array();
	  foreach ($jsonArray as $subArray) {
		$returnSubSubArray = array();
		if (isset($subArray->children)) {
			$returnSubSubArray = $this->parseJsonArray($subArray->children, $subArray->id);
		}

		$return[] = array('id' => $subArray->id, 'parentID' => $parentID);
		$return = array_merge($return, $returnSubSubArray);
	  }
	  return $return;
	}

	function delete_cat() {
        //check_permission(6,'json');
		$id = $this->input->post("id");
		$res=0;
		$pwhere = array('parent'=>$id);
		$parent_data = $this->common_model->get_table_data('categories',$pwhere,'*',true);
		if($parent_data->num_rows()>0){
			$value = withErrors('Since the category having sub categories, cannot delete!!!');
		}else{
			$cwhere = array('id'=>$id);
			$cat_data = $this->common_model->get_table_data('categories',$cwhere,'*',true);
			$catName=$cat_data->row()->text;
			$res = $this->common_model->delete_table_data('categories',$cwhere);
			$logData['action']='delete';
	        $logData['description']='deleted the category '.$catName;
			$logData['dataId']=$id;
	        $logData['module']='categories';
	        $logData['table_name']='categories';	        
		}
		
		if ($res == 1){
			insert_a_log($logData);
			$value = withSuccess('Category ('.$catName.') deleted successfully');
		}else if ($res == - 1451){
			$value = withErrors('Category ('.$catName.') failed to delete!');
		}
		echo json_encode($value);
	}

	function get_sub_categories(){
		$parent=$this->input->post('parent');
		$where = array('parent' => $parent, 'status'=>1);
		$catQ=$this->common_model->get_table_data('categories',$where,'*',true);
		$res_data['data_list'] = array();
        $res_data['result'] = "success";
		if($catQ->num_rows()>0){
			foreach ($catQ->result() as $categories) {
				$res_data['data_list'][] = array(
					'id' => $categories->id,
					'text' => $categories->text,
				);
			}
		}	
		echo json_encode($res_data);
	}
}
