	<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Activitylog extends CI_Controller {

	function __construct(){
		parent::__construct();
        check_admin_session();
		$this->load->model("adminmodel","",true);
		$this->load->model("common_model","",true);
		$this->load->model("log_model","",true);
		$this->admin->nocache(); 
	}

    function index() {
		$data = $this->admin->common_admin_files();
        $data['title'] = "Activity Log";
		$data['usersQ']=$this->common_model->get_table_data('admin_users','','*',true);
		$data['actionQ']=$this->log_model->get_log_actions();
		$data['moduleQ']=$this->log_model->get_log_modules();
        $this->load->view("admin/activity_log/activity_log_view", $data);
    }

    function get_datas() {
		$uid = get_adminId();
		$page = (int) $this->input->post('page');
		$filter_data=$this->input->post('filter_data');
		$get_total_rows = $this->log_model->filter_datas($filter_data,0,0,$uid);
		$item_per_page="10";
		foreach ($filter_data as $k => $v) {
			if (($v['type'] == 'perpage') && $v['value'] != "") {
				$item_per_page = (int)$v['value'];
			}
		}
		if(empty($page)){
			$page=1;
		}
		$data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);
		
		$data['logdata']=$this->log_model->filter_datas($filter_data,$data['item_per_page'],$data['page_position'],$uid);
		
        $str = $this->load->view("admin/activity_log/activity_log_tbl_view", $data, true);		
        $value = array(
            'result' => $str
        );
        echo json_encode($value);
    }
      
}
