<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Sell_property extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model("common_model","",true);
        $this->load->model("homemodel","",true);
	}

    function index(){
        $data = array();
        $data = $this->admin->common_files();
        $data['title']='Sell Property | TEASCORP (TRINITY Estates & Allied Services Corp)';
        $this->load->view("forms/sell_property_view",$data);
    }

    function save_form(){
        $data['p_category']=$this->input->post('p_category');
        $data['category']=$this->input->post('category');
        $data['tot_price']=$this->input->post('tot_price');
        // $data['sqft_price']=$this->input->post('sqft_price');
        $data['p_name']=$this->input->post('p_name');
        $data['tot_area']=$this->input->post('tot_area');
        $data['room']=$this->input->post('room');
        $data['bathroom']=$this->input->post('bathroom');
        $data['is_listed']=$this->input->post('is_listed');
        $features=$this->input->post('features');
        $data['p_location']=$this->input->post('p_location');
        $data['listed_details']=$this->input->post('listed_details');
        $data['message']=$this->input->post('message');

        $data['name']=$this->input->post('name');
        $data['email']=$this->input->post('email');
        $data['phone']=$this->input->post('phone');
        $data['w_phone']=$this->input->post('w_phone');
        $data['address']=$this->input->post('address');
        $data['createdDate']=cur_datetime();
        $data['status']=1;

        if($features!=''){
            $data['features']=json_encode($features);
        }
        //print_r($data);

        $result='fail';
        $msg='Failed to process your request, try again';
        $res_id=$this->common_model->insert_table_data('seller_form',$data);
        if($res_id>0){
            $rand_chars=strtoupper($this->admin->randomCodenum(3));
            $code='SF'.$rand_chars.$res_id;
            $dir = 'uploads/seller-forms/'.strtolower($code).'/';
            if(!file_exists($dir)){
                mkdir($dir , 0777, true);
            }
            $up_data['code']=$code;
            $where = array('id' => $res_id);
            $this->common_model->update_table_data('seller_form',$where,$up_data);
            $file_data['sellerId']=$res_id;
            $file_data['folder']=$dir;

            $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
            if(!empty($_FILES)){
                foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
                {
                    //$key = $i;
                    if(!empty($_FILES['attachment']['tmp_name'][$key])){
                        $file_name = $_FILES['attachment']['name'][$key];
                        $file_size =$_FILES['attachment']['size'][$key];
                        $file_tmp =$_FILES['attachment']['tmp_name'][$key];
                        $file_type=$_FILES['attachment']['type'][$key];        
                        $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                        if($file_size > 2048) {
                            $msg='File size should not exceed 2 MB';
                        }
                        if(in_array($ext,$extensions ) === true)
                        {
                            $target = $dir.$file_name;
                            if(file_exists($target)){
                                $file_name = rand(01,1000).$file_name;
                            }
                            $target = $dir.$file_name;
                            if(move_uploaded_file($file_tmp, $dir.$file_name))
                            {
                                $file_data['file_name']=$file_name;
                                $file_data['file_size']=$file_size;
                                $file_data['file_type']='.'.$ext;
                                $res_id=$this->common_model->insert_table_data('seller_form_attachments',$file_data);
                            }else{
                                $msg = 'Error in uploading file';               
                            }
                        
                        }else{
                            $msg = 'Error in uploading file. <br>File type is not allowed.';
                        }
                    }
                }
            }

            $msg='We have received your property details, we will get back to you soon';
            $result='success';

            $logData['module']='seller form';
            $logData['table_name']='seller_form';
            $logData['description']='seller form submission by '.$data['name'].', '.$data['email'].'('.$code.')';
            $logData['action']='submit';
            $logData['dataId']=$res_id;
            $logData['uname']=$data['name'];
            insert_log($logData);
        }
        //print_r($this->db->last_query());
        $value = array('result' => $result,'msg'=>$msg);
        echo json_encode($value);
    }

}