<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Request_demo extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model("common_model","",true);
	}

    function index(){
        $data = array();
        $data = $this->admin->common_files();
        $data['title']='Request Product Demo | DHI Verification - Enabling Informed Decision';
        $this->load->view("forms/request_demo_view",$data);
    }

    function save_form(){
        $data['name']=$this->input->post('name');
        $data['email']=$this->input->post('email');
        $data['phone']=$this->input->post('phone');
        $data['products']=$this->input->post('products');
        $data['createdDate']=cur_datetime();
        // $data['status']=1;
        $data['type']='demo';

        $result='fail';
        $msg='Failed to process your request, try again';
        $res_id=$this->common_model->insert_table_data('request_demo',$data);
        if($res_id>0){
            $msg='We have received your product demo request, we will get back to you soon';
            $result='success';

            $logData['module']='Demo';
            $logData['table_name']='request_demo';
            $logData['description']='Product demo request form submission by '.$data['name'].', '.$data['email'];
            $logData['action']='submit';
            $logData['dataId']=$res_id;
            $logData['uname']=$data['name'];
            insert_log($logData);
        }

        $value = array('result' => $result,'msg'=>$msg);
        echo json_encode($value);
    }

}