<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Projects extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model("common_model","",true);
        $this->load->model("listing_model","",true);
	}

    function index(){
        $data = array();
        $data = $this->admin->common_files();
        $data['title']='Projects';

        $sidebar_data['ptype'] = "";
        $sidebar_data['category'] = "";
        $sidebar_data['location'] = "";

        $sidebar_data['ptype'] = $this->input->get('ptype');
        $sidebar_data['category'] = $this->input->get('category');
        $sidebar_data['location'] = $this->input->get('location');
        if($sidebar_data['ptype']!=''){
            $parent=$sidebar_data['ptype'];
        }else{
            $parent='';
        }
        $sidebar_data['subcategoryQ']=$this->listing_model->get_categories_by_parent($parent);
        $sidebar_data['latestQ']=$this->listing_model->get_latest_projects(3,'');
        $sidebar_data['cat_countQ']=$this->listing_model->get_category_counts();
        $sidebar_data['rangesQ']=$this->listing_model->get_project_ranges();
        $data['sidebar_filter']=$this->load->view("projects/sidebar_filter_view",$sidebar_data,true);
        $this->load->view("projects/listing_view",$data);
    }

    function get_listings(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->listing_model->filter_projects($filter_data,0,0);
        $item_per_page="10";
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['listQ']=$this->listing_model->filter_projects($filter_data,$data['item_per_page'],$data['page_position']);
        $pagination = $this->listing_model->paginate_function($item_per_page, $data['page_number'], $get_total_rows, $data['total_pages']);        
        $str=$this->load->view("projects/listing_tbl_view",$data,true);        
        $counts='Found '.$get_total_rows.' projects';        
        $value=array(
            'str'=>$str,
            'paginate'=>$pagination,
            'counts'=>$counts,
        );
        echo json_encode($value);
    }

    function save_callback(){
        $data['data_id']=$this->input->post('p_code');
        $data['name']=$this->input->post('name');
        $data['email']=$this->input->post('email');
        $data['phone']=$this->input->post('phone');
        $data['createdDate']=cur_datetime();
        $data['status']=1;
        $data['type']='project';

        $result='fail';
        $msg='Failed to process your request, try again';
        $continue=1;
        if(isset($_POST['p_code']) && $_POST['p_code']!='' && $_POST['p_code']!='undefined'){
            $where = array('code' => $data['data_id']);
            $get_res=$this->common_model->get_table_data('projects',$where,'*','true');
            if($get_res->num_rows()>0){
                $continue=1;
            }else{
                $continue=0;
                $msg='There is a error in project data, please refresh this page and try again';
            }
        }

        if($continue==1){
            $res_id=$this->common_model->insert_table_data('callback_enquiries',$data);
            if($res_id>0){
                $msg='We have received your callback request, we will get back to you soon';
                $result='success';

                $logData['module']='Projects';
                $logData['table_name']='callback_enquiries';
                $logData['description']='callback enquiry form submission by '.$data['name'].', '.$data['email'].' for the project '.$data['data_id'].')';
                $logData['action']='callback enquiry';
                $logData['dataId']=$res_id;
                $logData['uname']=$data['name'];
                insert_log($logData);
            }
        }
        //print_r($this->db->last_query());

        $value = array('result' => $result,'msg'=>$msg);
        echo json_encode($value);
    }

    function get_sub_categories(){
        $parent=$this->input->post('parent');
        $catQ=$this->listing_model->get_categories_by_parent($parent);
        $res_data['data_list'] = array();
        $res_data['result'] = "success";
        if($catQ->num_rows()>0){
            foreach ($catQ->result() as $categories) {
                $res_data['data_list'][] = array(
                    'slug' => $categories->slug,
                    'text' => $categories->text,
                );
            }
        }   
        //print_r($this->db->last_query());
        echo json_encode($res_data);
    }

}