<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Forms extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model("common_model","",true);
	}

    function save_contact(){
        $data=$this->input->post();
        $data['createdDate']=cur_datetime();
        // $data['status']=1;
        $data['type']='contact';

        $value=withErrors('Failed to process your request, try again');
        $res_id=$this->common_model->insert_table_data('callback_enquiries',$data);
        if($res_id>0){
            $value=withSuccess('We have received your contact request, we will get back to you soon');

            $logData['module']='Contact';
            $logData['table_name']='callback_enquiries';
            $logData['description']='contact enquiry form submission by '.$data['name'].', '.$data['email'];
            $logData['action']='submit';
            $logData['dataId']=$res_id;
            $logData['uname']=$data['name'];
            insert_log($logData);
        }
        echo json_encode($value);
    }

    function save_career(){
        $data=$this->input->post();
        $data['createdDate']=cur_datetime();
        // $data['status']=2;
        $data['type']='career';

        $result='fail';
        $file_res=0;
        $msg='Failed to process your request, try again';
        $dir='uploads/resume/';
        if(!file_exists($dir)){
            mkdir($dir , 0777, true);
        }
        $extensions = array("PDF","pdf","docx","DOCX");
        if(!empty($_FILES)){
            //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
            for($i=0;$i<1;$i++)
            {
                $key = $i;
                if(!empty($_FILES['resume']['tmp_name'][$key])){
                    $file_name = $_FILES['resume']['name'][$key];
                    $file_size =$_FILES['resume']['size'][$key];
                    $file_tmp =$_FILES['resume']['tmp_name'][$key];
                    $file_type=$_FILES['resume']['type'][$key];        
                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                    if($file_size > 2000000) {
                        $msg='File size should not exceed 2 MB';
                    }else{
                        if(in_array($ext,$extensions ) === true)
                        {  

                            $target = $dir.$file_name;
                            if(file_exists($target)){
                                $file_name = rand(01,1000).$file_name;
                            }
                            $target = $dir.$file_name;
                            if(move_uploaded_file($file_tmp, $dir.$file_name))
                            {
                                $data['attachments']=$file_name;
                                $file_res=1;
                            }else{
                                $msg = 'Error in uploading file';               
                            }
                        
                        }else{
                            $msg = 'Error in uploading file. File type is not allowed.';
                        }
                    }
                }else{
                   $msg='Please select the file to upload';
                }
            }
        }else{
            $msg='Please select the file to upload';
        }
        if($file_res==1) {
            $res_id=$this->common_model->insert_table_data('callback_enquiries',$data);
            if($res_id>0){
                $msg='We have received request. We will get back to you shortly.';
                $result='success';

                $logData['module']='Careers';
                $logData['table_name']='callback_enquiries';
                $logData['description']='career form submission by '.$data['name'].', '.$data['email'];
                $logData['action']='submit';
                $logData['dataId']=$res_id;
                $logData['uname']=$data['name'];
                // insert_log($logData);
            }
        }else{
            $msg='Unable to upload the resume, please tr again.';
        }

    $value = array('status' => $result,'msg'=>$msg);
    echo json_encode($value);
    }    


    function contact_us(){
		$data=array();
        $data = $this->admin->common_files();
        $data['title']="Page Not Found";
		$this->load->view("forms/contact_view",$data);
	}

}