<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Buy_property extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model("common_model","",true);
        $this->load->model("homemodel","",true);
	}

    function index(){
        $data = array();
        $data = $this->admin->common_files();
        $data['title']='Buy Property | TEASCORP (TRINITY Estates & Allied Services Corp)';
        $this->load->view("forms/buy_property_view",$data);
    }

    function save_form(){
        $data['p_category']=$this->input->post('p_category');
        $data['category']=$this->input->post('category');
        $data['budget']=$this->input->post('budget');
        $data['room']=$this->input->post('room');
        $data['bathroom']=$this->input->post('bathroom');
        $data['area']=$this->input->post('area');
        $features=$this->input->post('features');
        $p_location=$this->input->post('p_location');
        $data['message']=$this->input->post('message');

        $data['name']=$this->input->post('name');
        $data['email']=$this->input->post('email');
        $data['phone']=$this->input->post('phone');
        $data['w_phone']=$this->input->post('w_phone');
        $data['address']=$this->input->post('address');
        $data['createdDate']=cur_datetime();
        $data['status']=1;

        if($features!=''){
            $data['features']=json_encode($features);
        }if($p_location!=''){
            $data['p_location']=json_encode($p_location);
        }
        //print_r($data);

        $result='fail';
        $msg='Failed to process your request, try again';
        $res_id=$this->common_model->insert_table_data('buyer_form',$data);
        if($res_id>0){
            $rand_chars=strtoupper($this->admin->randomCodenum(3));
            $code='BF'.$rand_chars.$res_id;
            $up_data['code']=$code;
            $where = array('id' => $res_id);
            $this->common_model->update_table_data('buyer_form',$where,$up_data);

            $msg='We have received your requirement details, we will get back to you soon';
            $result='success';

            $logData['module']='buyer form';
            $logData['table_name']='buyer_form';
            $logData['description']='buyer form submission by '.$data['name'].', '.$data['email'].'('.$code.')';
            $logData['action']='submit';
            $logData['dataId']=$res_id;
            $logData['uname']=$data['name'];
            insert_log($logData);
        }
        //print_r($this->db->last_query());
        $value = array('result' => $result,'msg'=>$msg);
        echo json_encode($value);
    }

    function get_sub_categories(){
        $parent=$this->input->post('parent');
        $catQ=$this->homemodel->get_categories_by_parent($parent);
        $res_data['data_list'] = array();
        $res_data['result'] = "success";
        if($catQ->num_rows()>0){
            foreach ($catQ->result() as $categories) {
                $res_data['data_list'][] = array(
                    'id' => $categories->id,
                    'slug' => $categories->slug,
                    'text' => $categories->text,
                );
            }
        }   
        echo json_encode($res_data);
    }

}